/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.daemon;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jrobin.core.Util;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.VlServer;

public class VlServerMonitoring {
    private static final Logger logger = Logger.getLogger(VlServerMonitoring.class);
    private IVlData data;
    public static final int TIME_INTERVAL = 300;
    private Thread checkVLCThread;
    private Thread updateSNMPDataThread;
    private Thread serverMonitorDeamonThread;
    private Runnable vLCchecker = new Runnable(){

        public void run() {
            for (VlServer server : VlServerMonitoring.this.data.getServers()) {
                server.checkVLC();
            }
        }
    };
    Runnable snmpDataUpdater = new Runnable(){

        public void run() {
            for (VlServer server : VlServerMonitoring.this.data.getServers()) {
                logger.log(Level.DEBUG, "Mise \u00e0 jour RRD de " + server.getName());
                server.updateSnmpData();
                server.updateRrdGraph();
            }
        }
    };
    Runnable serverMonitorDeamon = new Runnable(){

        public void run() {
            while (true) {
                logger.log(Level.DEBUG, "Test");
                VlServerMonitoring.this.startCheckVLCThread();
                VlServerMonitoring.this.startUpdateSNMPDataThread();
                try {
                    Thread.sleep(1000L * (300L - Util.getTime() % 300L));
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    };

    public boolean isCheckingVLC() {
        return this.checkVLCThread != null && this.checkVLCThread.isAlive();
    }

    public boolean isUpdatingSNMPData() {
        return this.updateSNMPDataThread != null && this.updateSNMPDataThread.isAlive();
    }

    public boolean isDeamonMonitoring() {
        return this.serverMonitorDeamonThread != null && this.serverMonitorDeamonThread.isAlive();
    }

    public synchronized void startCheckVLCThread() {
        if (!this.isCheckingVLC()) {
            this.checkVLCThread = new Thread(this.vLCchecker);
            this.checkVLCThread.setName("checkVLCThread");
            this.checkVLCThread.start();
        }
    }

    public synchronized void startUpdateSNMPDataThread() {
        if (!this.isUpdatingSNMPData()) {
            this.updateSNMPDataThread = new Thread(this.snmpDataUpdater);
            this.updateSNMPDataThread.setName("updateSNMPDataThread");
            this.updateSNMPDataThread.start();
        }
    }

    public synchronized void startServerMonitoringDeamon() {
        if (!this.isDeamonMonitoring()) {
            this.serverMonitorDeamonThread = new Thread(this.serverMonitorDeamon);
            this.serverMonitorDeamonThread.setName("serverMonitorThread");
            this.serverMonitorDeamonThread.start();
        }
    }

    public VlServerMonitoring(IVlData data) {
        this.data = data;
    }
}

