/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.model;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import org.videolan.vlma.model.StreamingStrategy;

public class Program
implements Serializable {
    private static final long serialVersionUID = -2723021707121558896L;
    private boolean broadcastState;
    private InetAddress ip;
    private int liveInterval;
    private int liveLength;
    private int liveRepetitions;
    private Date liveStart;
    private InetAddress player;
    private int priority;
    private String sapGroup;
    private String sapName;
    private StreamingStrategy streamingStrategy;

    public Program() {
        this.setLiveInterval(-1);
        this.setLiveRepetitions(1);
        this.setLiveLength(-1);
        this.liveStart = new Date();
        this.setIp(null);
        this.setPriority(50);
        this.setPlayer(null);
    }

    public boolean getBroadcastState() {
        return this.broadcastState;
    }

    public InetAddress getIp() {
        return this.ip;
    }

    public int getLiveInterval() {
        return this.liveInterval;
    }

    public int getLiveLength() {
        return this.liveLength;
    }

    public int getLiveRepetitions() {
        return this.liveRepetitions;
    }

    public Date getLiveStart() {
        return this.liveStart;
    }

    public InetAddress getPlayer() {
        return this.player;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getSapGroup() {
        return this.sapGroup;
    }

    public String getSapName() {
        return this.sapName;
    }

    public StreamingStrategy getStreamingStrategy() {
        return this.streamingStrategy;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Program)) {
            return false;
        }
        Program p = (Program)other;
        return this.getSapGroup().equals(p.getSapGroup()) && this.getSapName().equals(p.getSapName());
    }

    public int hashCode() {
        int result = 0;
        result += this.sapGroup == null ? 0 : this.sapGroup.hashCode();
        return result += this.sapGroup == null ? 0 : this.sapName.hashCode();
    }

    public boolean isTimeToPlay() {
        long now = System.currentTimeMillis();
        long when = this.getLiveStart().getTime();
        if (this.getLiveInterval() > 0) {
            return now >= when && (now - when) % (long)this.getLiveInterval() < (long)this.getLiveLength();
        }
        return now >= when;
    }

    public void setBroadcastState(boolean broadcastState) {
        this.broadcastState = broadcastState;
    }

    public void setIp(InetAddress ip) {
        this.ip = ip;
    }

    public void setLiveInterval(int liveInterval) {
        this.liveInterval = liveInterval;
    }

    public void setLiveLength(int liveLength) {
        this.liveLength = liveLength;
    }

    public void setLiveRepetitions(int liveRepetitions) {
        this.liveRepetitions = liveRepetitions;
    }

    public void setLiveStart(Date liveStart) {
        this.liveStart = liveStart;
    }

    public void setPlayer(InetAddress player) {
        this.player = player;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setSapGroup(String sapGroup) {
        this.sapGroup = sapGroup;
    }

    public void setSapName(String sapName) {
        this.sapName = sapName;
    }

    public void setStreamingStrategy(StreamingStrategy streamingStrategy) {
        this.streamingStrategy = streamingStrategy;
    }
}

