/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm.entity;

import java.awt.Image;
import java.io.UnsupportedEncodingException;
import rath.msnm.UserStatus;
import rath.msnm.msg.MimeUtility;

public class MsnFriend
implements UserStatus {
    private String groupIndex = "0";
    private String status = null;
    private String oldStatus = null;
    private String loginName = null;
    private String friendlyName = null;
    private String formatFriendlyName = null;
    private String code = null;
    private int accessValue = 0;
    private String photoContext;
    private boolean photoUpdated = true;
    private Image photo;

    public MsnFriend(String loginName) {
        this(loginName, null);
    }

    public MsnFriend(String loginName, String friendlyName) {
        this.loginName = loginName;
        this.friendlyName = friendlyName;
        this.setStatus("FLN");
    }

    public void setAccessValue(int access) {
        this.accessValue = access;
    }

    public int getAccessValue() {
        return this.accessValue;
    }

    public void setGroupIndex(String index) {
        this.groupIndex = index;
    }

    public String getGroupIndex() {
        return this.groupIndex;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setFriendlyName(String frName) {
        this.friendlyName = frName;
        this.formatFriendlyName = null;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getFormattedFriendlyName() {
        if (this.formatFriendlyName != null) {
            return this.formatFriendlyName;
        }
        if (this.friendlyName == null) {
            return null;
        }
        try {
            this.formatFriendlyName = MimeUtility.getURLDecodedString(this.friendlyName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.formatFriendlyName = this.friendlyName;
        }
        return this.formatFriendlyName;
    }

    public void setStatus(String st) {
        if (st == null) {
            st = "FLN";
        }
        this.oldStatus = this.status;
        this.status = st;
    }

    public String getOldStatus() {
        return this.oldStatus;
    }

    public String getStatus() {
        return this.status;
    }

    public String getFormattedStatus() throws IllegalAccessException {
        throw new IllegalAccessException("Deprecated");
    }

    public String toString() {
        return this.loginName + ":" + this.friendlyName + " (" + this.status + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o instanceof MsnFriend) {
            return this.loginName.equals(((MsnFriend)o).loginName);
        }
        return false;
    }

    public int hashCode() {
        return this.loginName.hashCode();
    }

    public String toFormattedString() {
        return this.loginName + ": " + this.getFormattedFriendlyName() + " (" + this.getStatus() + ")";
    }
}

