/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.monitor;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.videolan.vlma.OrderGiver;
import org.videolan.vlma.VLMaService;
import org.videolan.vlma.model.Media;
import org.videolan.vlma.model.Order;
import org.videolan.vlma.model.Program;
import org.videolan.vlma.monitor.Monitor;
import org.videolan.vlma.order.OrderSender;
import org.videolan.vlma.watcher.StreamWatcher;

public class OrderMonitor
implements Monitor {
    private static final Logger logger = Logger.getLogger(OrderMonitor.class);
    private Configuration configuration;
    private VLMaService vlmaService;
    private OrderGiver orderGiver;
    private OrderSender orderSender;
    private Thread orderMonitorThread;
    private Thread orderMonitorDaemonThread;
    private AtomicBoolean shouldRun = new AtomicBoolean(true);
    private StreamWatcher streamWatcher;
    private Runnable orderMonitor = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (OrderMonitor.this.orderGiver.isComputing()) {
                logger.info((Object)"Orders are already being given, computation delayed");
                return;
            }
            boolean shouldCompute = false;
            List<Media> medias = OrderMonitor.this.vlmaService.getMedias();
            for (Media media : medias) {
                Program program = media.getProgram();
                if (program == null || !program.isTimeToPlay()) continue;
                if (!OrderMonitor.this.streamWatcher.isPlayed(program)) {
                    logger.info((Object)("Program " + program.getSapName() + " is currently not played."));
                    Set<Order> set = OrderMonitor.this.vlmaService.getOrders();
                    synchronized (set) {
                        Iterator<Order> it = OrderMonitor.this.vlmaService.getOrders().iterator();
                        while (it.hasNext()) {
                            Order o = it.next();
                            if (!o.getMedias().contains((Object)media)) continue;
                            OrderMonitor.this.vlmaService.cancelOrder(o);
                            it.remove();
                            break;
                        }
                    }
                    program.setPlayer(null);
                    program.setBroadcastState(false);
                    shouldCompute = true;
                    continue;
                }
                program.setBroadcastState(true);
            }
            if (!shouldCompute) {
                for (Order order : OrderMonitor.this.vlmaService.getOrders()) {
                    for (Object media : order.getMedias()) {
                        if (media.getProgram() != null) continue;
                        logger.debug((Object)("The media " + media.getName() + " which belongs to an order has no more a program."));
                        shouldCompute = true;
                        break;
                    }
                    if (!shouldCompute) continue;
                    break;
                }
            }
            Set<Order> ordersToCancel = OrderMonitor.this.vlmaService.getOrdersToCancel();
            Iterator<Order> orderIt = ordersToCancel.iterator();
            while (orderIt.hasNext()) {
                Order order = orderIt.next();
                try {
                    Object media;
                    OrderMonitor.this.orderSender.stop(order);
                    media = ordersToCancel;
                    synchronized (media) {
                        orderIt.remove();
                    }
                    logger.debug((Object)("Order " + order + " cancelled"));
                }
                catch (IOException e) {}
            }
            if (shouldCompute) {
                logger.info((Object)"Ask for programs reassignment.");
                OrderMonitor.this.vlmaService.giveOrders();
            }
        }
    };
    private Runnable orderMonitorDaemon = new Runnable(){

        public void run() {
            OrderMonitor.this.shouldRun.set(true);
            while (OrderMonitor.this.shouldRun.get()) {
                try {
                    Thread.sleep(1000 * OrderMonitor.this.configuration.getInt("vlma.monitor.order.interval"));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!OrderMonitor.this.shouldRun.get()) continue;
                OrderMonitor.this.startOrderMonitoringThread();
            }
            logger.debug((Object)"OrderMonitor thread stopped.");
        }
    };

    public boolean isMonitoring() {
        return this.orderMonitorThread != null && this.orderMonitorThread.isAlive();
    }

    public boolean isDaemonMonitoring() {
        return this.orderMonitorDaemonThread != null && this.orderMonitorDaemonThread.isAlive();
    }

    public synchronized void startOrderMonitoringThread() {
        if (!this.isMonitoring()) {
            this.orderMonitorThread = new Thread(this.orderMonitor);
            this.orderMonitorThread.setName("OrderMonitorThread");
            this.orderMonitorThread.start();
        }
    }

    public synchronized void start() {
        if (!this.isDaemonMonitoring()) {
            logger.info((Object)("Starting " + this.getClass().getSimpleName()));
            this.orderMonitorDaemonThread = new Thread(this.orderMonitorDaemon);
            this.orderMonitorDaemonThread.setName("OrderMonitorDaemonThread");
            this.orderMonitorDaemonThread.start();
        }
    }

    public synchronized void stop() {
        logger.info((Object)("Stopping " + this.getClass().getSimpleName()));
        this.shouldRun.set(false);
        this.orderMonitorDaemonThread.interrupt();
    }

    public void setVlmaService(VLMaService vlmaService) {
        this.vlmaService = vlmaService;
    }

    public void setOrderGiver(OrderGiver orderGiver) {
        this.orderGiver = orderGiver;
    }

    public void setOrderSender(OrderSender orderSender) {
        this.orderSender = orderSender;
    }

    public void setStreamWatcher(StreamWatcher streamWatcher) {
        this.streamWatcher = streamWatcher;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

